/*{
    "DESCRIPTION": "Cheap Hue/Color Blend Mode",
    "CREDIT": "",
    "ISFVSN": "2",
    "CATEGORIES": [
        "Composition"
    ],
    "INPUTS": [
        {
            "NAME": "inputImage",
            "TYPE": "image"
        },
        {
            "NAME": "topImage",
            "TYPE": "image"
        },
        {
            "NAME": "dryWet",
            "TYPE": "float",
            "DEFAULT": 1.0,
            "MIN": 0.0,
            "MAX": 1.0
        }
    ]
    
}*/

void main() {
    vec4 bottom = IMG_NORM_PIXEL(inputImage, isf_FragNormCoord);
    vec4 top = IMG_NORM_PIXEL(topImage, isf_FragNormCoord);

    // Calculate the blending amounts for bottom and top images
    float amntBot = min(1.0, dryWet * 2.0);
    float amntTop = max(0.0, -1.0 + dryWet * 2.0);

    // Approximate luminance for bottom image
    float bottomLuminance = dot(bottom.rgb, vec3(0.299, 0.587, 0.114));

    // Replace the luminance of the top image with the luminance of the bottom image
    vec3 blendedColor = normalize(top.rgb) * bottomLuminance;

    // Create the final blended image with blackout effect
    vec3 returnMe = bottom.rgb * (1.0 - amntTop) + blendedColor * amntBot;
    returnMe = mix(returnMe, top.rgb, amntTop);

    // Set the output color with full alpha
    gl_FragColor = vec4(returnMe, 1.0);
}
